# 字符串转换整数 (atoi)
<div class="notranslate">
	<p>请你来实现一个&nbsp;<code>myAtoi(string s)</code>&nbsp;函数，使其能将字符串转换成一个 32 位有符号整数（类似 C/C++ 中的 <code>atoi</code> 函数）。</p>

	<p>函数&nbsp;<code>myAtoi(string s)</code> 的算法如下：</p>

	<ul>
		<li>读入字符串并丢弃无用的前导空格</li>
		<li>检查下一个字符（假设还未到字符末尾）为正还是负号，读取该字符（如果有）。 确定最终结果是负数还是正数。 如果两者都不存在，则假定结果为正。</li>
		<li>读入下一个字符，直到到达下一个非数字字符或到达输入的结尾。字符串的其余部分将被忽略。</li>
		<li>将前面步骤读入的这些数字转换为整数（即，"123" -&gt; 123， "0032" -&gt; 32）。如果没有读入数字，则整数为 <code>0</code> 。必要时更改符号（从步骤 2 开始）。</li>
		<li>如果整数数超过 32 位有符号整数范围 <code>[−2<sup>31</sup>,&nbsp; 2<sup>31&nbsp;</sup>− 1]</code>
			，需要截断这个整数，使其保持在这个范围内。具体来说，小于 <code>−2<sup>31</sup></code> 的整数应该被固定为 <code>−2<sup>31</sup></code> ，大于
			<code>2<sup>31&nbsp;</sup>− 1</code> 的整数应该被固定为 <code>2<sup>31&nbsp;</sup>− 1</code> 。
		</li>
		<li>返回整数作为最终结果。</li>
	</ul>

	<p><strong>注意：</strong></p>

	<ul>
		<li>本题中的空白字符只包括空格字符 <code>' '</code> 。</li>
		<li>除前导空格或数字后的其余字符串外，<strong>请勿忽略</strong> 任何其他字符。</li>
	</ul>

	<p>&nbsp;</p>

	<p><strong>示例&nbsp;1：</strong></p>

	<pre><strong>输入：</strong>s = "42"
<strong><br />输出：</strong>42
<strong><br />解释：</strong>加粗的字符串为已经读入的字符，插入符号是当前读取的字符。
第 1 步："42"（当前没有读入字符，因为没有前导空格）
		 ^
第 2 步："42"（当前没有读入字符，因为这里不存在 '-' 或者 '+'）
		 ^
第 3 步："<strong>42</strong>"（读入 "42"）
		   ^
解析得到整数 42 。
由于 "42" 在范围 [-2<sup>31</sup>, 2<sup>31</sup> - 1] 内，最终结果为 42 。</pre>

	<p><strong>示例&nbsp;2：</strong></p>

	<pre><strong>输入：</strong>s = "   -42"
<strong><br />输出：</strong>-42
<strong><br />解释：</strong>
第 1 步："   -42"（读入前导空格，但忽视掉）
			^
第 2 步："   -42"（读入 '-' 字符，所以结果应该是负数）
			 ^
第 3 步："   -<strong>42</strong>"（读入 "42"）
			   ^
解析得到整数 -42 。
由于 "-42" 在范围 [-2<sup>31</sup>, 2<sup>31</sup> - 1] 内，最终结果为 -42 。
</pre>

	<p><strong>示例&nbsp;3：</strong></p>

	<pre><strong>输入：</strong>s = "4193 with words"
<strong><br />输出：</strong>4193
<strong><br />解释：</strong>
第 1 步："4193 with words"（当前没有读入字符，因为没有前导空格）
		 ^
第 2 步："4193 with words"（当前没有读入字符，因为这里不存在 '-' 或者 '+'）
		 ^
第 3 步："<strong>4193</strong> with words"（读入 "4193"；由于下一个字符不是一个数字，所以读入停止）
		     ^
解析得到整数 4193 。
由于 "4193" 在范围 [-2<sup>31</sup>, 2<sup>31</sup> - 1] 内，最终结果为 4193 。
</pre>

	<p><strong>示例&nbsp;4：</strong></p>

	<pre><strong>输入：</strong>s = "words and 987"
<strong><br />输出：</strong>0
<strong><br />解释：</strong>
第 1 步："words and 987"（当前没有读入字符，因为没有前导空格）
		 ^
第 2 步："words and 987"（当前没有读入字符，因为这里不存在 '-' 或者 '+'）
		 ^
第 3 步："words and 987"（由于当前字符 'w' 不是一个数字，所以读入停止）
		 ^
解析得到整数 0 ，因为没有读入任何数字。
由于 0 在范围 [-2<sup>31</sup>, 2<sup>31</sup> - 1] 内，最终结果为 0 。</pre>

	<p><strong>示例&nbsp;5：</strong></p>

	<pre><strong>输入：</strong>s = "-91283472332"
<strong><br />输出：</strong>-2147483648
<strong><br />解释：</strong>
第 1 步："-91283472332"（当前没有读入字符，因为没有前导空格）
		 ^
第 2 步："-91283472332"（读入 '-' 字符，所以结果应该是负数）
		  ^
第 3 步："-<strong>91283472332</strong>"（读入 "91283472332"）
		            ^
解析得到整数 -91283472332 。
由于 -91283472332 小于范围 [-2<sup>31</sup>, 2<sup>31</sup> - 1] 的下界，最终结果被截断为 -2<sup>31</sup> = -2147483648 。</pre>

	<p>&nbsp;</p>

	<p><strong>提示：</strong></p>

	<ul>
		<li><code>0 &lt;= s.length &lt;= 200</code></li>
		<li><code>s</code> 由英文字母（大写和小写）、数字（<code>0-9</code>）、<code>' '</code>、<code>'+'</code>、<code>'-'</code> 和
			<code>'.'</code> 组成
		</li>
	</ul>
</div>
<p>以下错误的选项是？</p>
## aop
### before
```cpp
#include <bits/stdc++.h>
using namespace std;
```
### after
```cpp
int main()
{
    Solution sol;
    cout << sol.myAtoi("-42") << endl;
    return 0;
}
```

## 答案
```cpp
class Solution
{
public:
    int myAtoi(string s)
    {
        int index = 0;

        while (index < s.length() && s[index] == ' ')
            index++;

        int sign = 1;
        if (index < s.length() && (s[index] == '+' || s[index] == '-'))
        {
            if (s[index] == '-')
                sign = -1;
            index++;
        }

        int val = 0;
        while (index < s.length() && (s[index] >= '0' && s[index] <= '9'))
        {
            if (val > (2147483647 - (s[index] - '0')) / 10)
            {
                if (sign == -1)
                    return -2147483648;
                else
                    return 2147483647;
            }

            val = val * 10 + (s[index] - '0');
            index++;
        }

        return val;
    }
};
```
## 选项

### A
```cpp
class Solution
{
public:
    int myAtoi(string str)
    {
        int d = 0;
        istringstream is(str);
        is >> d;
        return d;
    }
};
```

### B
```cpp
class Solution
{
public:
    int myAtoi(string str)
    {
        int i = 0;
        while (' ' == str[i])
            ++i; 
        long flag = 1;
        if ('+' == str[i])
        {
            flag = 1;
            return fun(str, ++i, flag);
        }
        else if ('-' == str[i])
        {
            flag = -1;
            return fun(str, ++i, flag);
        }
        else if (str[i] - '0' >= 0 && str[i] - '0' <= 9)
        {
            flag = 1;
            return fun(str, i, flag);
        }
        else
        {
            return 0;
        }
    }
    int fun(string str, int i, const long flag) 
    {
        long res = 0;
        while (str[i] - '0' >= 0 && str[i] - '0' <= 9)
        {
            res = res * 10 + (str[i++] - '0');
            if (res * flag > pow(2, 31) - 1)
                return INT_MAX;
            if (res * flag < -pow(2, 31))
                return INT_MIN;
        }
        res = res * flag;
        return int(res);
    }
};
```

### C
```cpp
class Solution
{
public:
    int myAtoi(string str)
    {
        int max = INT_MAX / 10;
        int min = INT_MIN / 10;
        int max_f = INT_MAX % 10;
        int min_f = INT_MIN % 10;
        int len = str.length();
        bool flag = false;
        int sum = 0;
        int symbol = 1;
        for (int i = 0; i < len; i++)
        {
            char ch = str[i];
            if (!flag)
            {
                if (ch == ' ')
                    continue;
                else if (ch == '+')
                    flag = true;
                else if (ch == '-')
                {
                    flag = true;
                    symbol = -1;
                }
                else if (ch <= '9' && ch >= '0')
                    flag = true;
                else
                    break;
            }
            else if (ch > '9' || ch < '0')
                break;
            if (ch <= '9' && ch >= '0')
            {
                int pos = symbol * (ch - '0');
                if (sum > max || (sum == max && pos >= max_f))
                    return INT_MAX;
                if (sum < min || (sum == min && pos <= min_f))
                    return INT_MIN;
                sum = sum * 10 + pos;
            }
        }
        return sum;
    }
};
```
